IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'RC_CLI_BEM_MAIS_PROMOCAO_EST_MC')
BEGIN

CREATE TABLE [dbo].[RC_CLI_BEM_MAIS_PROMOCAO_EST_MC](
	[ID]					BIGINT IDENTITY(1, 1) NOT NULL,
	[ID_PROMOCAO]			BIGINT NOT NULL,
	[CD_EMP]				INT NOT NULL,
	[CD_MC]					INT NOT NULL,
	[DS_MC]					VARCHAR(200) NOT NULL,
	[ID_NIVEL]				INT NOT NULL,
	[PERC_DESC]				MONEY NOT NULL,
	[VLR_UNIT]				MONEY NOT NULL,
	CONSTRAINT PK_RC_CLI_BEM_MAIS_PROMOCAO_EST_MC PRIMARY KEY CLUSTERED ([ID])
) ON [PRIMARY]

END
GO

IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_MC_EST_MC')
BEGIN
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_MC ADD CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_MC_EST_MC FOREIGN KEY (CD_EMP, CD_MC) REFERENCES EST_MC (CD_EMP, CD_MC)
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_MC CHECK CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_MC_EST_MC
END
GO


IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_MC_RC_CLI_BEM_MAIS_PROMOCAO')
BEGIN
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_MC ADD CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_MC_RC_CLI_BEM_MAIS_PROMOCAO FOREIGN KEY (ID_PROMOCAO) REFERENCES RC_CLI_BEM_MAIS_PROMOCAO (ID)
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_MC CHECK CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_MC_RC_CLI_BEM_MAIS_PROMOCAO
END
GO

IF NOT EXISTS (SELECT * FROM SYS.indexes WHERE NAME = 'UK_RC_CLI_BEM_MAIS_PROMOCAO_EST_MC_ID_PROMOCAO_CD_EMP_CD_MC')
BEGIN
	CREATE UNIQUE INDEX UK_RC_CLI_BEM_MAIS_PROMOCAO_EST_MC_ID_PROMOCAO_CD_EMP_CD_MC ON RC_CLI_BEM_MAIS_PROMOCAO_EST_MC (ID_PROMOCAO, CD_EMP, CD_MC)
END